/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entity.rule;

import zigen.plugin.db.core.SQLUtil;


public class MySQLSqlFactory extends DefaultSqlFactory {
	
	public String createOneToManySql(String schema, String columnName) {
		
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT");
		sb.append("        TABLE_NAME");
		sb.append("    FROM");
		sb.append("        information_schema.COLUMNS");
		sb.append("    WHERE");
		sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schema) + "'");
		sb.append("        AND COLUMN_COMMENT LIKE '%@ManyToOne%'");
		sb.append("        AND COLUMN_NAME = '" + SQLUtil.encodeQuotation(columnName) + "'");
		sb.append("        ORDER BY TABLE_NAME");
		
		return sb.toString();
		
	}
	
	public String createOneToOneSql(String schema, String columnName) {
		
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT");
		sb.append("        TABLE_NAME");
		sb.append("    FROM");
		sb.append("        information_schema.COLUMNS");
		sb.append("    WHERE");
		sb.append("        TABLE_SCHEMA = '" + SQLUtil.encodeQuotation(schema) + "'");
		sb.append("        AND COLUMN_COMMENT LIKE '%@OneToOne%'");
		sb.append("        AND COLUMN_NAME = '" + SQLUtil.encodeQuotation(columnName) + "'");
		sb.append("        ORDER BY TABLE_NAME");
		
		return sb.toString();
		
	}
}